---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
aliases:
  - Compatibility
  - Conflict
---

# Compatibility : Conflict (relation)

> Can components co-bind without interference vs exhibit persistent tension.

---

## Definition

- Fit/clash pattern
- Work/fight relation
- Match/tension test
- Blend/strain check

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Fit check | Can bind | `Monitor`, `Fit` |
| Work test | Can run | `Check`, `Work` |
| Match scan | Can mix | `Test`, `Match` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Fit check | Goes well | "Works together" |
| Work test | Flows right | "No clash" |
| Match scan | Feels good | "Good match" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Can bind | Goes well | How fit works |
| Can run | Flows right | How work flows |
| Can mix | Feels good | How match forms |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Force fit | Energy match |
| Networks | Link work | Node fit |
| Cognition | Mind match | Think fit |
| Systems | Flow work | Move match |

---

## Scale Effects

How Compatibility manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum fit | Wave match |
| λV | Gate work | State fit |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase match | Pattern fit |
| ∇S | Structure work | Clear match |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave work | Light fit |
| λV | Field match | Space work |

Note: At extreme scales, compatibility faces fundamental limits (e.g., quantum matching at ε, causal fitting at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: fit precision
- c: work speed
- ψA: phase match
- λV: gate fit

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern fit | Wave match |
| Human | λV | Gate work | Flow fit |
| Cosmic | ψA | Phase match | Field work |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Bad fit | Pattern clash | Won't work |
| Human | No match | Flow break | Can't blend |
| Cosmic | Work fail | Field clash | No fit |

---

## Diagnostic Checklist

Technical tests:
- [ ] Fit checked
- [ ] Work proven
- [ ] Match clear
- [ ] Blend works

Humane tests:
- [ ] Goes well
- [ ] Flows right
- [ ] Feels good
- [ ] Works smooth

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical compatibility nor experiential harmony alone captures its full meaning.

---

## See Also

- [[Dependency : Constraint (relation)]]
- [[Equivalence : Isomorphism (relation)]]
- [[Symmetry : Asymmetry (relation)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented